<?php
add_action('admin_menu', function() {
    add_menu_page(
        __('G-Ads Settings', 'gads-cookie'),
        __('جی ادز', 'gads-cookie'),
        'manage_options',
        'gads-cookie-settings',
        'gads_cookie_settings_page',
        plugins_url('../assets/logo.svg', __FILE__)
    );
});

function gads_cookie_settings_page() {
    if (isset($_POST['gads_create_privacy_page'])) {
        gads_create_privacy_page();
    }
    ?>
    <div class="wrap">
        <h1><?php echo esc_html('تنظیمات بنر کوکی', 'gads-cookie'); ?></h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('gads_cookie_options');
            do_settings_sections('gads-cookie-settings');
            submit_button();
            ?>
        </form>
        <form method="post">
            <button class="button button-secondary" name="gads_create_privacy_page"><?php echo esc_html('ایجاد صفحه حریم خصوصی', 'gads-cookie'); ?></button>
        </form>
    </div>
    <?php
}

add_action('admin_init', function() {
    register_setting('gads_cookie_options', 'gads_cookie_settings', 'gads_cookie_sanitize');
    function gads_cookie_sanitize($input) {
        $output = [];
        $output['gads_cookie_enabled'] = isset($input['gads_cookie_enabled']) ? 1 : 0;
        $output['gads_cookie_message'] = sanitize_text_field($input['gads_cookie_message'] ?? '');
        $output['gads_cookie_accept_text'] = sanitize_text_field($input['gads_cookie_accept_text'] ?? '');
        $output['gads_cookie_color'] = sanitize_hex_color($input['gads_cookie_color'] ?? '');
        $output['gads_cookie_position'] = sanitize_text_field($input['gads_cookie_position'] ?? '');
        return $output;
    }


    add_settings_section('gads_cookie_main', '', null, 'gads-cookie-settings');

    add_settings_field('gads_cookie_enabled', __('نمایش بنر', 'gads-cookie'), function() {
        $options = get_option('gads_cookie_settings');
        echo '<input type="checkbox" name="gads_cookie_settings[gads_cookie_enabled]" value="1"' . checked(1, $options['gads_cookie_enabled'] ?? 1, false) . ' />';
    }, 'gads-cookie-settings', 'gads_cookie_main');

    add_settings_field('gads_cookie_message', __('متن بنر', 'gads-cookie'), function() {
        $options = get_option('gads_cookie_settings');
        echo '<textarea name="gads_cookie_settings[gads_cookie_message]" rows="3" cols="50">'. esc_textarea($options['gads_cookie_message'] ?? 'جهت بهبود خدمات از کوکی ها استفاده می‌کنیم.') .'</textarea>';
    }, 'gads-cookie-settings', 'gads_cookie_main');

    add_settings_field('gads_cookie_accept_text', __('متن دکمه پذیرش', 'gads-cookie'), function() {
        $options = get_option('gads_cookie_settings');
        echo '<input type="text" name="gads_cookie_settings[gads_cookie_accept_text]" value="'. esc_attr($options['gads_cookie_accept_text'] ?? 'پذیرفتن') .'" />';
    }, 'gads-cookie-settings', 'gads_cookie_main');

    add_settings_field('gads_cookie_color', __('رنگ دکمه پذیرش', 'gads-cookie'), function() {
        $options = get_option('gads_cookie_settings');
        echo '<input type="color" name="gads_cookie_settings[gads_cookie_color]" value="'. esc_attr($options['gads_cookie_color'] ?? '#28B446') .'" />';
    }, 'gads-cookie-settings', 'gads_cookie_main');

    add_settings_field('gads_cookie_position', __('موقعیت بنر', 'gads-cookie'), function() {
        $options = get_option('gads_cookie_settings');
        $val = $options['gads_cookie_position'] ?? 'bottom-left';
        echo '<select name="gads_cookie_settings[gads_cookie_position]">
            <option value="bottom-left"'.selected($val, 'bottom-left', false).'>پایین چپ</option>
            <option value="bottom-right"'.selected($val, 'bottom-right', false).'>پایین راست</option>
        </select>';
    }, 'gads-cookie-settings', 'gads_cookie_main');
});