<?php
function gads_create_privacy_page() {
    $site_name = get_bloginfo('name');
    $site_url = get_site_url();

    $html = file_get_contents(plugin_dir_path(__FILE__) . '../assets/privacy-template.html');
    $html = str_replace(['(site name)', '(site URL)'], [$site_name, $site_url], $html);

    $page = get_page_by_path('privacy-policy');
    if (!$page) {
        wp_insert_post([
            'post_title'   => 'Privacy Policy',
            'post_name'    => 'privacy-policy',
            'post_content' => $html,
            'post_status'  => 'publish',
            'post_type'    => 'page'
        ]);
    } else {
        add_action('admin_notices', function () {
            echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('عالی، صفحه حریم شخصی از قبل ایجاد شده است.', 'gads-cookie') . '</p></div>';
        });
    }
}