/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/js/view/custom-cursor.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/js/view/custom-cursor.js":
/*!**************************************!*\
  !*** ./src/js/view/custom-cursor.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("/**\n * Render Circle Cursor\n *\n * @param {*} $scope\n * @param {*} $\n */\nfunction renderCircleCursor($scope, $) {\n  var cursorSettings = $scope.data('eael-cursor-settings');\n  var elementId = $scope.data('id');\n  var dotHtml = '';\n  if (cursorSettings !== null && cursorSettings !== void 0 && cursorSettings.dot_show) {\n    dotHtml = '<div id=\"eael-cursor-dot-' + elementId + '\"></div>';\n  }\n  var cursorHtml = '<div id=\"eael-cursor-' + elementId + '\">' + dotHtml + '</div>';\n  $($scope).append(DOMPurify.sanitize(cursorHtml));\n\n  // Create cursor elements\n  var $cursor = $scope.find('#eael-cursor-' + elementId);\n\n  // Set initial cursor styles (normal state)\n  $cursor.css({\n    width: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_size) + 'px',\n    height: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_size) + 'px',\n    border: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_thickness) + 'px ' + (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_type) + ' ' + (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_color),\n    borderRadius: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_radius) + '%',\n    position: 'fixed',\n    pointerEvents: 'none',\n    zIndex: '999999999999999',\n    top: 0,\n    left: 0,\n    display: 'none',\n    willChange: 'transform',\n    transition: 'width 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), height 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), border 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), border-radius 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), background-color 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94)'\n  });\n  if (cursorSettings !== null && cursorSettings !== void 0 && cursorSettings.dot_show) {\n    var $dot = $scope.find('#eael-cursor-dot-' + elementId);\n    $dot.css({\n      width: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_size) + 'px',\n      height: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_size) + 'px',\n      background: cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_color,\n      borderRadius: (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_radius) + '%',\n      position: 'absolute',\n      top: '50%',\n      left: '50%',\n      transform: 'translate(-50%, -50%)',\n      willChange: 'transform',\n      transition: 'width 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), height 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), background-color 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), border-radius 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 250ms cubic-bezier(0.25, 0.46, 0.45, 0.94)'\n    });\n  }\n  if ('circle' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.cursor_type)) {\n    $scope.css('cursor', 'none');\n  }\n  var isPointerState = false;\n\n  // Default pointer selectors\n  var defaultPointerSelectors = ['a[href]', 'button', 'input[type=\"button\"]', 'input[type=\"submit\"]', 'input[type=\"reset\"]', 'input[type=\"checkbox\"]', 'input[type=\"radio\"]', 'label', 'select', 'summary'];\n\n  // Function to apply cursor styles based on state\n  function applyCursorStyles() {\n    var isPointer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;\n    var state = isPointer ? '_pointer' : '';\n    var size = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['circle_size' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_size);\n    var thickness = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['circle_thickness' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_thickness);\n    var type = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['circle_type' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_type);\n    var color = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['circle_color' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_color);\n    var radius = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['circle_radius' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.circle_radius);\n\n    // Apply cursor styles while preserving transitions\n    $cursor[0].style.width = size + 'px';\n    $cursor[0].style.height = size + 'px';\n    $cursor[0].style.border = thickness + 'px ' + type + ' ' + color;\n    $cursor[0].style.borderRadius = radius + '%';\n\n    // Apply dot styles if enabled\n    if (cursorSettings !== null && cursorSettings !== void 0 && cursorSettings.dot_show || cursorSettings !== null && cursorSettings !== void 0 && cursorSettings['dot_show' + state]) {\n      var _$dot = $scope.find('#eael-cursor-dot-' + elementId);\n      if (_$dot.length) {\n        var dotSize = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['dot_size' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_size);\n        var dotColor = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['dot_color' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_color);\n        var dotRadius = (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings['dot_radius' + state]) || (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.dot_radius);\n\n        // Apply dot styles while preserving transitions\n        _$dot[0].style.width = dotSize + 'px';\n        _$dot[0].style.height = dotSize + 'px';\n        _$dot[0].style.backgroundColor = dotColor;\n        _$dot[0].style.borderRadius = dotRadius + '%';\n      }\n    }\n  }\n  $scope.on('mouseenter mousemove', function () {\n    $cursor.show();\n  }).on('mouseleave', function () {\n    $cursor.hide();\n    isPointerState = false;\n    applyCursorStyles(false);\n  }).on('mousemove', function (e) {\n    // Use clientX/Y for viewport-relative positioning and update cursor position instantly\n    var mouseX = e.clientX;\n    var mouseY = e.clientY;\n\n    // Update cursor position directly using CSS transform for instant tracking\n    $cursor[0].style.transform = \"translate3d(\".concat(mouseX, \"px, \").concat(mouseY, \"px, 0) translate(-50%, -50%)\");\n\n    // Update dot position if enabled (keep centered)\n    if (cursorSettings !== null && cursorSettings !== void 0 && cursorSettings.dot_show) {\n      var _$dot2 = $scope.find('#eael-cursor-dot-' + elementId);\n      if (_$dot2.length) {\n        _$dot2[0].style.transform = 'translate(-50%, -50%)';\n      }\n    }\n\n    // Check if hovering over pointer elements\n    var target = e.target;\n    var isOverPointerElement = defaultPointerSelectors.some(function (selector) {\n      try {\n        return target.matches(selector) || target.closest(selector);\n      } catch (err) {\n        return false;\n      }\n    });\n\n    // Update cursor state if changed\n    if (isOverPointerElement !== isPointerState) {\n      isPointerState = isOverPointerElement;\n      applyCursorStyles(isPointerState);\n    }\n    if (isPointerState && 'circle' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.cursor_type_pointer)) {\n      $(e.target).css('cursor', 'none');\n    }\n    if ('circle' !== (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.cursor_type_pointer)) {\n      if (isPointerState) {\n        $cursor.hide();\n      } else {\n        $cursor.show();\n      }\n    } else if ('circle' !== (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.cursor_type)) {\n      if (isPointerState) {\n        $cursor.show();\n      } else {\n        $cursor.hide();\n      }\n    }\n  });\n}\n\n/**\n * Initialize Following Dots Trail\n * \n * @param {*} $scope \n * @param {*} $ \n */\nfunction initFollowingDotsTrail($scope, settings, $) {\n  var elementId = $scope.data('id');\n  var trailCount = (settings === null || settings === void 0 ? void 0 : settings.trail_count) || 12;\n  var trailSize = (settings === null || settings === void 0 ? void 0 : settings.trail_size) || 10;\n  var trailOpacity = (settings === null || settings === void 0 ? void 0 : settings.trail_opacity) || 0.5;\n  var trailRadius = (settings === null || settings === void 0 ? void 0 : settings.trail_radius) || 50;\n  var trailSpeed = (settings === null || settings === void 0 ? void 0 : settings.trail_speed) || 0.08;\n  var trailColors = settings === null || settings === void 0 ? void 0 : settings.trail_colors;\n  var dots = [];\n  var mouse = {\n    x: 0,\n    y: 0\n  };\n  var $trailContainer = $('<div>', {\n    id: 'eael-trails-' + elementId,\n    css: {\n      position: 'absolute',\n      top: 0,\n      left: 0,\n      width: '100%',\n      height: '100%',\n      pointerEvents: 'none',\n      zIndex: 9999999999,\n      display: 'none'\n    }\n  }).appendTo($scope.css('position', 'relative'));\n\n  // Create trail dots\n  for (var i = 0; i < trailCount; i++) {\n    var $dot = $('<div>', {\n      id: 'eael-trail-' + elementId + '-' + i,\n      css: {\n        width: trailSize + 'px',\n        height: trailSize + 'px',\n        background: trailColors[i],\n        opacity: trailOpacity,\n        borderRadius: trailRadius + '%',\n        position: 'absolute',\n        pointerEvents: 'none',\n        zIndex: 9999999999\n      }\n    }).appendTo($trailContainer);\n    dots.push({\n      $el: $dot,\n      x: 0,\n      y: 0\n    });\n  }\n  var idleTimer = null;\n  var hideOnIdle = settings === null || settings === void 0 ? void 0 : settings.trail_hide_on_idle;\n  var idleTimeout = (settings === null || settings === void 0 ? void 0 : settings.trail_idle_timeout) * 1000 || 3000; // 3 seconds of inactivity\n\n  function resetIdleTimer() {\n    clearTimeout(idleTimer);\n    $trailContainer.show();\n    idleTimer = setTimeout(function () {\n      if (hideOnIdle) {\n        $trailContainer.fadeOut('slow');\n      }\n    }, idleTimeout);\n  }\n  $scope.on('mousemove', function (e) {\n    var offset = $scope.offset();\n    mouse.x = e.pageX - offset.left;\n    mouse.y = e.pageY - offset.top;\n    resetIdleTimer();\n  }).on('mouseenter', function () {\n    resetIdleTimer();\n  }).on('mouseleave', function () {\n    clearTimeout(idleTimer);\n    $trailContainer.fadeOut('slow');\n  });\n  function animate() {\n    var x = mouse.x,\n      y = mouse.y;\n    dots.forEach(function (dot, i) {\n      var next = dots[i - 1] || {\n        x: x,\n        y: y\n      };\n      dot.x += (next.x - dot.x) * trailSpeed;\n      dot.y += (next.y - dot.y) * trailSpeed;\n      dot.$el.css('transform', \"translate(\".concat(dot.x, \"px, \").concat(dot.y, \"px)\"));\n    });\n    requestAnimationFrame(animate);\n  }\n  animate();\n}\n\n/**\n * Initialize 90s Cursor Trail by using 90s Cursor Effects library\n *\n * @param {*} $scope\n * @param {*} options\n * @param {*} type\n */\nfunction initialize90sCursorTrail($scope, options, type, settings) {\n  var cursorTrail = false;\n  var hideOnIdle = settings === null || settings === void 0 ? void 0 : settings.trail_hide_on_idle;\n  var idleTimeout = settings === null || settings === void 0 ? void 0 : settings.trail_idle_timeout;\n  var inactivityTimer = null;\n  var inactivityTimeout = idleTimeout * 1000 || 3000; // 3 seconds of inactivity before destroying\n\n  function resetInactivityTimer() {\n    clearTimeout(inactivityTimer);\n    inactivityTimer = setTimeout(function () {\n      if (hideOnIdle) {\n        if (cursorTrail) {\n          $scope.find(' > canvas').fadeOut('slow', function () {\n            if (cursorTrail && typeof cursorTrail.destroy === 'function') {\n              cursorTrail.destroy();\n            }\n            cursorTrail = false;\n          });\n        }\n      }\n    }, inactivityTimeout);\n  }\n  $scope.on('mouseenter mousemove', function () {\n    if (type !== (settings === null || settings === void 0 ? void 0 : settings.trail_effect)) {\n      return;\n    }\n    if (!cursorTrail) {\n      if (typeof eaelCursorEffects !== 'undefined' && eaelCursorEffects[type]) {\n        cursorTrail = new eaelCursorEffects[type](options);\n      }\n    }\n    resetInactivityTimer();\n  }).on('mouseleave', function () {\n    clearTimeout(inactivityTimer);\n    if (cursorTrail) {\n      $scope.find(' > canvas').fadeOut('slow', function () {\n        if (cursorTrail && typeof cursorTrail.destroy === 'function') {\n          cursorTrail.destroy();\n        }\n        cursorTrail = false;\n      });\n    }\n  });\n}\nfunction initPhantomSmoke($scope, $settings, $) {\n  var target = $scope[0];\n  var options = {};\n  if ($settings !== null && $settings !== void 0 && $settings.trail_ghost_size) {\n    options.size = $settings === null || $settings === void 0 ? void 0 : $settings.trail_ghost_size;\n  }\n  if ($settings !== null && $settings !== void 0 && $settings.trail_ghost_color) {\n    options.mainColor = $settings === null || $settings === void 0 ? void 0 : $settings.trail_ghost_color;\n  }\n  var ghostTrail = false;\n  var inactivityTimer = null;\n  var hideOnIdle = $settings === null || $settings === void 0 ? void 0 : $settings.trail_hide_on_idle;\n  var idleTimeout = $settings === null || $settings === void 0 ? void 0 : $settings.trail_idle_timeout;\n  var inactivityTimeout = idleTimeout * 1000 || 3000; // 3 seconds of inactivity before pausing\n\n  function resetInactivityTimer() {\n    clearTimeout(inactivityTimer);\n    inactivityTimer = setTimeout(function () {\n      if (hideOnIdle) {\n        if (ghostTrail) {\n          $scope.find(' > canvas').fadeOut('slow', function () {\n            if (ghostTrail && typeof ghostTrail.destroy === 'function') {\n              ghostTrail.destroy();\n            }\n            ghostTrail = false;\n          });\n        }\n      }\n    }, inactivityTimeout);\n  }\n  $scope.on('mouseenter mousemove', function () {\n    if (!ghostTrail) {\n      if (typeof SmokyGhostTrail !== 'undefined') {\n        ghostTrail = new SmokyGhostTrail(target, options);\n      }\n    } else {\n      if (ghostTrail && typeof ghostTrail.start === 'function') {\n        ghostTrail.start();\n      }\n    }\n    resetInactivityTimer();\n  }).on('mouseleave', function () {\n    clearTimeout(inactivityTimer);\n    if (ghostTrail) {\n      $scope.find(' > canvas').fadeOut('slow', function () {\n        if (ghostTrail && typeof ghostTrail.destroy === 'function') {\n          ghostTrail.destroy();\n        }\n        ghostTrail = false;\n      });\n    }\n  });\n}\n\n/**\n * Initialize spiritecho\n *\n * @param {*} $scope\n * @param {*} $\n */\nfunction initspiritecho($scope, settings, $) {\n  var target = $scope[0];\n  var options = {};\n\n  // Map settings to GhostCursorTrail options\n  if (settings !== null && settings !== void 0 && settings.ghost_following_size) {\n    options.scale = settings === null || settings === void 0 ? void 0 : settings.ghost_following_size;\n  }\n  if (settings !== null && settings !== void 0 && settings.ghost_following_color) {\n    options.ghostColor = settings === null || settings === void 0 ? void 0 : settings.ghost_following_color;\n  }\n  if (settings !== null && settings !== void 0 && settings.ghost_following_eye_color) {\n    options.eyeColor = settings === null || settings === void 0 ? void 0 : settings.ghost_following_eye_color;\n  }\n\n  // Set container to the element\n  options.container = target;\n  var ghostTrail = false;\n  var inactivityTimer = null;\n  var hideOnIdle = settings === null || settings === void 0 ? void 0 : settings.trail_hide_on_idle;\n  var idleTimeout = settings === null || settings === void 0 ? void 0 : settings.trail_idle_timeout;\n  var inactivityTimeout = idleTimeout * 1000 || 3000; // 3 seconds of inactivity before pausing\n\n  function resetInactivityTimer() {\n    clearTimeout(inactivityTimer);\n    inactivityTimer = setTimeout(function () {\n      if (hideOnIdle) {\n        if (ghostTrail) {\n          $scope.find(' > .ghost-cursor-trail, > .ghost-cursor-trail-svg').fadeOut('slow', function () {\n            if (ghostTrail) {\n              var _ghostTrail;\n              (_ghostTrail = ghostTrail) === null || _ghostTrail === void 0 || _ghostTrail.destroy();\n            }\n            ghostTrail = false;\n          });\n        }\n      }\n    }, inactivityTimeout);\n  }\n  $scope.on('mouseenter mousemove', function () {\n    if (!ghostTrail) {\n      if (typeof GhostCursorTrail !== 'undefined') {\n        ghostTrail = new GhostCursorTrail(options);\n        if (ghostTrail && typeof ghostTrail.start === 'function') {\n          ghostTrail.start();\n        }\n      }\n    } else {\n      if (ghostTrail && typeof ghostTrail.start === 'function') {\n        ghostTrail.start();\n      }\n    }\n    resetInactivityTimer();\n  }).on('mouseleave', function () {\n    clearTimeout(inactivityTimer);\n    if (ghostTrail) {\n      $scope.find(' > .ghost-cursor-trail, > .ghost-cursor-trail-svg').fadeOut('slow', function () {\n        if (ghostTrail) {\n          var _ghostTrail2;\n          (_ghostTrail2 = ghostTrail) === null || _ghostTrail2 === void 0 || _ghostTrail2.destroy();\n        }\n        ghostTrail = false;\n      });\n    }\n  });\n}\n\n/**\n * Initialize Snowflake Cursor\n * \n * @param {*} $scope \n * @param {*} settings \n * @param {*} $ \n */\nfunction initfrostsparkles($scope, settings, $) {\n  var trailEmojis = settings !== null && settings !== void 0 && settings.trail_emojis ? settings.trail_emojis.split(',').filter(function (emoji) {\n    return emoji !== '';\n  }) : ['❄️'];\n  var windyEffect = (settings === null || settings === void 0 ? void 0 : settings.trail_windy_efect) || false;\n  var options = {\n    element: $scope[0],\n    emojis: trailEmojis,\n    windy: windyEffect\n  };\n  initialize90sCursorTrail($scope, options, 'frostsparkles', settings);\n}\n\n/**\n * Initialize Pointer Particles\n * \n * @param {*} $scope \n * @param {*} settings \n * @param {*} $ \n */\nfunction inittrailparticles($scope, settings, $) {\n  var particleCount = (settings === null || settings === void 0 ? void 0 : settings.particle_count) || 30;\n  var particleSize = (settings === null || settings === void 0 ? void 0 : settings.particle_size) || 5;\n  var particleColor = (settings === null || settings === void 0 ? void 0 : settings.particle_color) || '#ff00ff';\n  var options = {\n    element: $scope[0],\n    particleCount: particleCount,\n    pointSize: particleSize,\n    colors: [particleColor]\n  };\n  var ponterParticles = false;\n  $scope.on('mouseenter mousemove', function () {\n    if (!ponterParticles) {\n      if (typeof PointerParticles !== 'undefined') {\n        ponterParticles = new PointerParticles($scope[0]);\n        if (ponterParticles && typeof ponterParticles.start === 'function') {\n          ponterParticles.start();\n        }\n      }\n    } else {\n      if (ponterParticles && typeof ponterParticles.start === 'function') {\n        ponterParticles.start();\n      }\n    }\n  }).on('mouseleave', function () {\n    if (ponterParticles) {\n      $scope.find(' > canvas').fadeOut('slow', function () {\n        if (ponterParticles && typeof ponterParticles.destroy === 'function') {\n          ponterParticles.destroy();\n        }\n        ponterParticles = false;\n      });\n    }\n  });\n}\n\n/**\n * Initialize Ink Line\n * \n * @param {*} $scope \n * @param {*} settings \n * @param {*} $ \n */\nfunction initinktrail($scope, settings, $) {\n  var options = {\n    container: $scope[0]\n  };\n  if (settings !== null && settings !== void 0 && settings.ink_line_color) {\n    options.color = settings === null || settings === void 0 ? void 0 : settings.ink_line_color;\n  }\n  var inktrail = false;\n  $scope.on('mouseenter mousemove', function () {\n    if (!inktrail) {\n      if (typeof eaelInkLine !== 'undefined') {\n        inktrail = eaelInkLine(options);\n      }\n    }\n  }).on('mouseleave', function () {\n    if (inktrail) {\n      $scope.find(' > canvas').fadeOut('slow', function () {\n        if (inktrail && typeof inktrail.destroy === 'function') {\n          inktrail.destroy();\n        }\n        inktrail = false;\n      });\n    }\n  });\n}\n\n/**\n * Initialize Glowing Boxes\n * \n * @param {*} $scope \n * @param {*} settings \n * @param {*} $ \n */\nfunction initGlowingBoxes($scope, settings, $) {\n  var opacity = (settings === null || settings === void 0 ? void 0 : settings.glowing_boxes_opacity) || 1;\n  opacity = opacity / 10;\n  var id = 'eael-glowing-boxes-' + $scope.data('id');\n  var trailLength = (settings === null || settings === void 0 ? void 0 : settings.glowing_boxes_trail_length) || 20;\n  var size = (settings === null || settings === void 0 ? void 0 : settings.glowing_boxes_size) || 50;\n  var borderRadius = (settings === null || settings === void 0 ? void 0 : settings.glowing_boxes_border_radius) || '1px';\n  var interval = (settings === null || settings === void 0 ? void 0 : settings.glowing_boxes_interval) || 10;\n  var hueSpeed = (settings === null || settings === void 0 ? void 0 : settings.glowing_boxes_hue_speed) || 2;\n  var options = {\n    container: $scope[0],\n    // any CSS selector or HTMLElement\n    trailLength: trailLength,\n    size: size,\n    interval: interval,\n    hueSpeed: hueSpeed,\n    borderRadius: borderRadius,\n    id: id,\n    opacity: opacity\n  };\n  var glowingBoxes = false;\n  $scope.on('mouseenter mousemove', function () {\n    if (!glowingBoxes) {\n      if (typeof eaelGlowingBoxes !== 'undefined') {\n        glowingBoxes = new eaelGlowingBoxes(options);\n        if (glowingBoxes && typeof glowingBoxes.init === 'function') {\n          glowingBoxes.init();\n        }\n      }\n    }\n  }).on('mouseleave', function () {\n    if (glowingBoxes) {\n      $scope.find(' > .' + id).fadeOut('slow', function () {\n        if (glowingBoxes && typeof glowingBoxes.destroy === 'function') {\n          glowingBoxes.destroy();\n        }\n        glowingBoxes = false;\n      });\n    }\n  });\n}\n\n/**\n * Initialize Color Balls\n * \n * @param {*} $scope \n * @param {*} settings \n * @param {*} $ \n */\nfunction initColorBalls($scope, settings, $) {\n  var id = 'eael-color-balls-' + $scope.data('id');\n  var colors = (settings === null || settings === void 0 ? void 0 : settings.color_balls_colors) || [];\n  var options = {\n    container: $scope[0],\n    id: id,\n    colors: colors\n  };\n  var colorBalls = false;\n  $scope.on('mouseenter mousemove', function () {\n    if (!colorBalls) {\n      if (typeof eaelColorBalls !== 'undefined') {\n        colorBalls = eaelColorBalls(options);\n      }\n    }\n  }).on('mouseleave', function () {\n    if (colorBalls) {\n      $scope.find(' > .' + id).fadeOut('slow', function () {\n        if (colorBalls && typeof colorBalls.destroy === 'function') {\n          colorBalls.destroy();\n        }\n        colorBalls = false;\n      });\n    }\n  });\n}\nvar CustomCursor = function CustomCursor($scope, $) {\n  var cursorType = $scope.data('eael-cursor');\n  var cursorSettings = $scope.data('eael-cursor-settings');\n  if ('circle' === cursorType || 'circle' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.cursor_type) || 'circle' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.cursor_type_pointer)) {\n    renderCircleCursor($scope, $);\n  }\n  if ('yes' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail)) {\n    if ('following_dots' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initFollowingDotsTrail($scope, cursorSettings, $);\n    } else if ('colorSwipe' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initRainbowTrail($scope, cursorSettings, $);\n    } else if ('phantomsmoke' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initPhantomSmoke($scope, cursorSettings, $);\n    } else if ('spiritecho' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initspiritecho($scope, cursorSettings, $);\n    } else if ('textFlag' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initTextFlag($scope, cursorSettings, $);\n    } else if ('frostsparkles' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initfrostsparkles($scope, cursorSettings, $);\n    } else if ('trailparticles' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      inittrailparticles($scope, cursorSettings, $);\n    } else if ('inktrail' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initinktrail($scope, cursorSettings, $);\n    } else if ('glowingBoxes' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initGlowingBoxes($scope, cursorSettings, $);\n    } else if ('colorBalls' === (cursorSettings === null || cursorSettings === void 0 ? void 0 : cursorSettings.trail_effect)) {\n      initColorBalls($scope, cursorSettings, $);\n    }\n  }\n};\njQuery(window).on(\"elementor/frontend/init\", function () {\n  if (eael.elementStatusCheck('eaelCustomCursor2') || window.isEditMode) {\n    return false;\n  }\n  elementorFrontend.hooks.addAction(\"frontend/element_ready/widget\", CustomCursor);\n  elementorFrontend.hooks.addAction(\"frontend/element_ready/container\", CustomCursor);\n  elementorFrontend.hooks.addAction(\"frontend/element_ready/section\", CustomCursor);\n});\njQuery(window).on(\"elementor/frontend/init\", function () {\n  if (eael.elementStatusCheck('eaelCustomCursor3')) {\n    return false;\n  }\n  var pageId = jQuery('body').data('page-id');\n  if (!pageId) {\n    return;\n  }\n  var rawData = jQuery('body').find('#eael-cursor-trail-settings-' + pageId).text();\n  if (!rawData) {\n    return;\n  }\n  var parsedData = JSON.parse(rawData);\n  jQuery('body').data('eael-cursor-settings', parsedData);\n  CustomCursor(jQuery('body'), jQuery);\n});\n\n//# sourceURL=webpack:///./src/js/view/custom-cursor.js?");

/***/ })

/******/ });